package chess4j.board;

public enum CastlingRights {
	WHITE_KINGSIDE(0,"K"),
	WHITE_QUEENSIDE(1,"Q"),
	BLACK_KINGSIDE(2,"k"),
	BLACK_QUEENSIDE(3,"q");
	
	private int _value;
	private String _label;
		
	private CastlingRights(int value,String label) {
		_value=value;
		_label=label;
	}
	
	public boolean equals(CastlingRights cr) {
		if (cr==null) return false;
		return cr.getValue()==_value;
	}
	
	public int getValue() {
		return _value;
	}
	
	public String getLabel() {
		return _label;
	}

	public static CastlingRights getCastlingRights(int value) {
		
		for (CastlingRights cr : CastlingRights.values()) {
			if (cr.getValue()==value) {
				return cr;
			}
		}
		throw new IllegalArgumentException("CastlingRights value not found: " + value);
	}

}
